# Installation Guide for ReportLab PDF Generation

## Overview
This project has been updated to use `ReportLab` directly for PDF generation instead of `xhtml2pdf` or `WeasyPrint`. This provides better compatibility with shared cPanel hosting environments and avoids complex dependency issues.

## Requirements
- Python 3.7+
- Django 4.2+
- cPanel hosting with Python support

## Installation Steps

### 1. Install Dependencies
```bash
pip install -r requirements.txt
```

### 2. Key Dependencies
- `reportlab>=3.6.0` - Direct PDF generation engine (no HTML conversion needed)
- `Pillow>=9.0.0` - Image processing support
- `Django>=4.2.0` - Web framework
- Other standard Django packages

### 3. cPanel Deployment
1. Upload your project files to cPanel
2. Create a Python app in cPanel
3. Set Python version to 3.7 or higher
4. Install requirements using cPanel's Python package manager
5. Configure your Django settings for production

### 4. Environment Variables
Make sure to set these in your cPanel environment:
```bash
DJANGO_SETTINGS_MODULE=marketizr.settings
SECRET_KEY=your_secret_key_here
DEBUG=False
ALLOWED_HOSTS=your_domain.com
```

## PDF Generation Features

### Invoice PDFs
- Professional invoice layout with Marketizr branding
- Company information and contact details
- Client billing information
- Itemized billing table with proper styling
- GST calculation and totals
- Terms and conditions
- Professional signature section

### Quote PDFs
- Quotation format with company branding
- Item details and pricing table
- Professional styling and layout
- Company information and contact details
- Terms and conditions
- Signature section

### Payment Receipts
- Payment confirmation with receipt details
- Invoice summary and payment information
- Client details and payment method
- Professional receipt format
- Thank you message

## Technical Benefits

### Why ReportLab?
1. **No HTML Conversion**: Direct PDF generation without HTML parsing
2. **Better Performance**: Faster PDF generation
3. **Fewer Dependencies**: Minimal external package requirements
4. **Better Compatibility**: Works reliably on all platforms including Windows
5. **Professional Output**: High-quality PDFs with precise control over layout

### Memory Efficiency
- Lower memory usage compared to HTML-based solutions
- Better performance on shared hosting
- No temporary HTML files created

## Troubleshooting

### Common Issues
1. **Font Issues**: ReportLab has excellent font support and handles Unicode well
2. **Memory Usage**: Much more memory-efficient than HTML-based solutions
3. **Dependencies**: Minimal dependencies reduce installation issues
4. **Platform Compatibility**: Works reliably on Windows, Linux, and macOS

### Performance Tips
- Generate PDFs on-demand rather than storing them permanently
- Use appropriate image sizes for logos
- Consider caching generated PDFs for frequently accessed documents

## Support
For issues related to ReportLab, check:
- [ReportLab Documentation](https://www.reportlab.com/docs/reportlab-userguide.pdf)
- [ReportLab GitHub](https://github.com/ReportLab/reportlab)

## Migration Notes
- All PDF generation methods now use ReportLab directly
- No HTML templates needed for PDF generation
- Better error handling and reliability
- No changes needed to existing models or business logic
- Improved performance and compatibility
