# Simple Automatic Invoice Creation

## How It Works

When you set `is_invoice_converted: true` on a quote, the system **automatically creates ONE invoice** with the same information.

## Simple Process

### 1. Create Quote
```json
POST /api/marketizr/quotes/
{
    "lead": "lead-uuid",
    "quote_date": "2025-08-07",
    "gst": "100.00",
    "currency": "INR",
    "items": [
        {
            "item_name": "Product A",
            "description": "Description A",
            "qty": 2,
            "rate": "100.00",
            "amount": "200.00"
        }
    ]
}
```

### 2. Convert to Invoice
```json
PUT /api/marketizr/quotes/{quote_id}/
{
    "is_invoice_converted": true
}
```

**OR**

```bash
POST /api/marketizr/quotes/{quote_id}/convert-to-invoice/
```

### 3. Get Invoice
```bash
GET /api/marketizr/quotes/{quote_id}/get-invoice/
```

## What Happens Automatically

✅ **ONE Invoice Created** per quote (no duplicates)  
✅ **All Items Copied** from quote to invoice  
✅ **Same Information** - lead, GST, currency  
✅ **PDF Generated** automatically  
✅ **No Manual Work** - everything automatic  

## Example Response

```json
{
    "id": "invoice-uuid",
    "invoice_number": "INV-001116",
    "invoice_date": "2025-08-07",
    "lead": "lead-uuid",
    "quote": "quote-uuid",
    "gst": "100.00",
    "currency": "INR",
    "items": [
        {
            "item_name": "Product A",
            "description": "Description A",
            "qty": 2,
            "rate": "100.00",
            "amount": "200.00"
        }
    ],
    "lead_data": {
        "company": "Company Name",
        "first_name": "John",
        "last_name": "Doe"
    }
}
```

## Important Rules

🔒 **ONE Quote = ONE Invoice** - No duplicates  
🔒 **Same Information** - All data copied from quote  
🔒 **Automatic** - No manual intervention needed  
🔒 **Unique** - Each quote gets exactly one invoice  

## Test Results

✅ **ONE invoice created** per quote  
✅ **All items copied** from quote to invoice  
✅ **Same information** - GST, currency, lead  
✅ **PDF generated** automatically  
✅ **No duplicates** - Only one invoice per quote  

Your system now creates exactly **ONE invoice per quote** with the same information! 🎉 
