from crm.models import Payment
from crm.serializers.quote import PaymentSerializer
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from django.db.models import Sum, Q
from crm.models.payments import PaymentMethod
from expence.models.expence import ExpenceOfficeExpense, ExpenseAccount
from expence.models.fund import FundTransfer
from expence.serializers import FundTransferSerializer, OfficeExpenseSerializer
from students.models import Student, StudentPayment
from students.serializers import StudentSerializer
from students.serializers import StudentPaymentSerializer
from django.db.models import Count



class CashTotalPaymentView(APIView):
    def get(self, request):
        # Payment totals (cash income)
        payment_total = Payment.objects.filter(
            payment_method=PaymentMethod.CASH
        ).aggregate(total=Sum('amount'))['total'] or 0

       
        # Use the exact stored string value
        student_payment_total = StudentPayment.objects.filter(
        payment_method='Cash'  # Matches your DB data
        ).aggregate(total=Sum('amount'))['total'] or 0

        # Same for the data queryset
        
        # Expense totals (cash outgoing)
        expense_total = ExpenceOfficeExpense.objects.filter(
            paid_through=ExpenseAccount.CASH.value
        ).aggregate(total=Sum('amount'))['total'] or 0

        fund_transfer = FundTransfer.objects.filter(payment_mode=ExpenseAccount.CASH.value).aggregate(total=Sum('amount_received'))['total'] or 0


        # Calculate net cash value
        total_income = payment_total + student_payment_total + fund_transfer
        net_cash_value = total_income - expense_total

        # Get actual data objects for serialization
        payments = Payment.objects.filter(payment_method=PaymentMethod.CASH)
        student_payments = StudentPayment.objects.filter(payment_method='Cash')
        expenses = ExpenceOfficeExpense.objects.filter(paid_through=ExpenseAccount.CASH.value)
        fund_transfer_data  = FundTransfer.objects.filter(payment_mode=ExpenseAccount.CASH.value)

        return Response({
            'payment_total': payment_total,
            'student_payment_total': student_payment_total,
            'expense_total': expense_total,
            'fund_transfer': fund_transfer,
            'total_income': total_income,
            'net_cash_value': net_cash_value,
            'payments_data': PaymentSerializer(payments, many=True).data,
            'student_payments_data': StudentPaymentSerializer(student_payments, many=True).data,
            'expenses_data': OfficeExpenseSerializer(expenses, many=True).data,
            'fund_transfer_data': FundTransferSerializer(fund_transfer_data, many=True).data
        })
    

class OtherTotalPaymentView(APIView):
    def get(self, request):
            methods_excluding_cash = [m.value for m in PaymentMethod if m != PaymentMethod.CASH]

            total_payments = Payment.objects.filter(payment_method__in=methods_excluding_cash).aggregate(total=Sum('amount'))['total'] or 0
            total_student_payments = StudentPayment.objects.filter(payment_method__in=methods_excluding_cash).aggregate(total=Sum('amount'))['total'] or 0
            total_expenses = ExpenceOfficeExpense.objects.filter(paid_through__in=methods_excluding_cash).aggregate(total=Sum('amount'))['total'] or 0
            fund_transfer = FundTransfer.objects.filter(payment_mode__in=methods_excluding_cash).aggregate(total=Sum('amount_received'))['total'] or 0

            print(total_expenses, "total_expenses")
            print(fund_transfer, "fund_transfer")

            total_income = total_payments + total_student_payments + fund_transfer
            net_cash_value = total_income - total_expenses

            payments = Payment.objects.filter(payment_method__in=methods_excluding_cash)
            student_payments = StudentPayment.objects.filter(payment_method__in=methods_excluding_cash)
            expenses = ExpenceOfficeExpense.objects.filter(paid_through__in=methods_excluding_cash)
            fund_transfers = FundTransfer.objects.filter(payment_mode__in=methods_excluding_cash)

            return Response({
                'total_payments': total_payments,
                'total_student_payments': total_student_payments,
                'total_expenses': total_expenses,
                'total_fund_transfer' : fund_transfer,
                'total_income': total_income,
                'net_cash_value': net_cash_value,
                'payments_data': PaymentSerializer(payments, many=True).data,
                'student_payments_data': StudentPaymentSerializer(student_payments, many=True).data,
                'expenses_data': OfficeExpenseSerializer(expenses, many=True).data,
                'fund_transfers_data': FundTransferSerializer(fund_transfers, many=True).data,
            })
