from django.shortcuts import render
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
import requests
from datetime import datetime



class DownloadPunchDataView(APIView):
    def get(self, request):
        empcode = request.query_params.get('Empcode')
        from_date = request.query_params.get('FromDate')
        to_date = request.query_params.get('ToDate')
        
        try:
            if from_date:
                parsed_from_date = datetime.strptime(from_date, '%m/%d/%Y')
                formatted_from_date = parsed_from_date.strftime('%d/%m/%Y')
            else:
                formatted_from_date = from_date
                
            if to_date:
                parsed_to_date = datetime.strptime(to_date, '%m/%d/%Y')
                formatted_to_date = parsed_to_date.strftime('%d/%m/%Y')
            else:
                formatted_to_date = to_date
                
        except ValueError as e:
            return Response({
                'Error': True,
                'Msg': f'Invalid date format. Please use MM/dd/yyyy format. Error: {str(e)}'
            }, status=status.HTTP_400_BAD_REQUEST)
        
        url = f'https://api.etimeoffice.com/api/DownloadInOutPunchData?Empcode={empcode}&FromDate={formatted_from_date}&ToDate={formatted_to_date}'
        headers = {
            "Authorization": "Basic bWFya2V0aXpyOk1BUktFVElaUjpLbDE0QHBsdG46dHJ1ZQ=="
        }
        
        try:
            response = requests.get(url, headers=headers)
            return Response(response.json())
        except requests.RequestException as e:
            return Response({
                'Error': True,
                'Msg': f'Failed to connect to attendance API: {str(e)}'
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class DownloadPunchDataMCIDView(APIView):
    def get(self, request):
        empcode = request.query_params.get('Empcode')
        from_date = request.query_params.get('FromDate')
        to_date = request.query_params.get('ToDate')
        
      
        try:
            if from_date:
                parsed_from_date = datetime.strptime(from_date, '%m/%d/%Y_%H:%M')
                formatted_from_date = parsed_from_date.strftime('%d/%m/%Y_%H:%M')
            else:
                formatted_from_date = from_date
                
            if to_date:
                parsed_to_date = datetime.strptime(to_date, '%m/%d/%Y_%H:%M')
                formatted_to_date = parsed_to_date.strftime('%d/%m/%Y_%H:%M')
            else:
                formatted_to_date = to_date
                
        except ValueError as e:
            return Response({
                'Error': True,
                'Msg': f'Invalid datetime format. Please use MM/dd/yyyy_HH:mm format. Error: {str(e)}'
            }, status=status.HTTP_400_BAD_REQUEST)
        
        url = f'https://api.etimeoffice.com/api/DownloadPunchDataMCID?Empcode={empcode}&FromDate={formatted_from_date}&ToDate={formatted_to_date}'
        headers = {
            "Authorization": "Basic bWFya2V0aXpyOk1BUktFVElaUjpLbDE0QHBsdG46dHJ1ZQ=="
        }
        
        try:
            response = requests.get(url, headers=headers)
            return Response(response.json())
        except requests.RequestException as e:
            return Response({
                'Error': True,
                'Msg': f'Failed to connect to attendance API: {str(e)}'
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class DownloadLastPunchDataView(APIView):
    def get(self, request):
        empcode = request.query_params.get('Empcode')
        last_record = request.query_params.get('LastRecord')
        
        if not empcode:
            return Response({
                'Error': True,
                'Msg': 'Empcode parameter is required'
            }, status=status.HTTP_400_BAD_REQUEST)
        
        if not last_record:
            return Response({
                'Error': True,
                'Msg': 'LastRecord parameter is required'
            }, status=status.HTTP_400_BAD_REQUEST)
        
        url = f'https://api.etimeoffice.com/api/DownloadLastPunchData?Empcode={empcode}&LastRecord={last_record}'
        headers = {
            "Authorization": "Basic bWFya2V0aXpyOk1BUktFVElaUjpLbDE0QHBsdG46dHJ1ZQ=="
        }
        
        try:
            response = requests.get(url, headers=headers)
            return Response(response.json())
        except requests.RequestException as e:
            return Response({
                'Error': True,
                'Msg': f'Failed to connect to attendance API: {str(e)}'
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)
