from django.db import models
import uuid
from enum import Enum
from lib.choices import choices_the_options


class FeedbackEnum(Enum):
    GENERALFEEDBACK = 'General Feedback'
    REPORTANISSUE = 'Report an Issue'
    PERMISSIONISSUE = 'Permission Issue'
    OTHER = 'Other'


class Feedback(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    types_feedback = models.CharField(max_length=100, choices=choices_the_options(
        FeedbackEnum), default=FeedbackEnum.GENERALFEEDBACK.value)
    is_satisfied = models.BooleanField(default=False)
    message = models.TextField(max_length=500, null=True, blank=True)
    username = models.CharField(max_length=100, null=True, blank=True)
    file_attached = models.FileField(
        upload_to='media/feedback_files/', null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return self.types_feedback

    class Meta:
        ordering = ['-created_at']
