from rest_framework.views import APIView
from clients.models import Feedback
from clients.serializers import FeedbackSerializer
from rest_framework import status
from rest_framework.response import Response


class FeedbackView(APIView):
    def post(self, request):
        serializer = FeedbackSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

    def get(self, request):
        feedbacks = Feedback.objects.all()
        feedbacks_serializer = FeedbackSerializer(feedbacks, many=True)

        if feedbacks_serializer.data:
            return Response(feedbacks_serializer.data, status=status.HTTP_200_OK)

        return Response({"message": "No feedbacks found"}, status=status.HTTP_404_NOT_FOUND)
