from django.contrib import admin
from .models import Batch, AllCourse, Chapter, Lesson, CourseEnrollment, LessonProgress, Question, Exam, ExamAnswer, ExamResult, Certificate

@admin.register(Batch)
class BatchAdmin(admin.ModelAdmin):
    list_display = ['name', 'trainer', 'start_date', 'end_date', 'is_active']
    list_filter = ['is_active', 'start_date', 'end_date']
    search_fields = ['name', 'trainer__name']
    ordering = ['-created_at']

@admin.register(AllCourse)
class AllCourseAdmin(admin.ModelAdmin):
    list_display = ['name', 'trainer', 'price', 'batch', 'is_published', 'created_at']
    list_filter = ['is_published', 'batch', 'trainer']
    search_fields = ['name', 'description', 'trainer__name']
    ordering = ['-created_at']

@admin.register(Chapter)
class ChapterAdmin(admin.ModelAdmin):
    list_display = ['title', 'course', 'order', 'is_published']
    list_filter = ['is_published', 'course']
    search_fields = ['title', 'course__name']
    ordering = ['course', 'order']

@admin.register(Lesson)
class LessonAdmin(admin.ModelAdmin):
    list_display = ['title', 'chapter', 'lesson_type', 'duration_minutes', 'order', 'is_published']
    list_filter = ['lesson_type', 'is_published', 'chapter__course']
    search_fields = ['title', 'chapter__title', 'chapter__course__name']
    ordering = ['chapter', 'order']

@admin.register(CourseEnrollment)
class CourseEnrollmentAdmin(admin.ModelAdmin):
    list_display = ['student', 'course', 'enrollment_date', 'is_active']
    list_filter = ['is_active', 'enrollment_date', 'course']
    search_fields = ['student__name', 'course__name']
    ordering = ['-enrollment_date']

@admin.register(LessonProgress)
class LessonProgressAdmin(admin.ModelAdmin):
    list_display = ['enrollment', 'lesson', 'is_completed', 'time_watched', 'completed_at']
    list_filter = ['is_completed', 'completed_at']
    search_fields = ['enrollment__student__name', 'lesson__title']
    ordering = ['-updated_at']

@admin.register(Question)
class QuestionAdmin(admin.ModelAdmin):
    list_display = ['course', 'question_text', 'correct_answer', 'created_at']
    list_filter = ['course', 'correct_answer']
    search_fields = ['question_text', 'course__name']

@admin.register(Exam)
class ExamAdmin(admin.ModelAdmin):
    list_display = ['enrollment', 'started_at', 'expires_at', 'score', 'is_passed']
    list_filter = ['is_passed', 'started_at']
    search_fields = ['enrollment__student__profile__name', 'enrollment__course__name']

@admin.register(Certificate)
class CertificateAdmin(admin.ModelAdmin):
    list_display = ['certificate_number', 'student', 'course', 'exam_score', 'certificate_date']
    list_filter = ['certificate_date', 'course']
    search_fields = ['certificate_number', 'student__profile__name', 'course__name']
