from django.core.management.base import BaseCommand
from course.models import AllCourse, Question

class Command(BaseCommand):
    help = 'Populate sample questions for courses'

    def add_arguments(self, parser):
        parser.add_argument('course_id', type=str, help='Course ID to add questions to')

    def handle(self, *args, **options):
        course_id = options['course_id']
        
        try:
            course = AllCourse.objects.get(id=course_id)
        except AllCourse.DoesNotExist:
            self.stdout.write(self.style.ERROR(f'Course with ID {course_id} not found'))
            return

        sample_questions = [
            {
                'question_text': 'What is Django?',
                'option_a': 'A web framework',
                'option_b': 'A database',
                'option_c': 'A programming language',
                'option_d': 'An IDE',
                'correct_answer': 'A'
            },
            {
                'question_text': 'Which language is Django written in?',
                'option_a': 'JavaScript',
                'option_b': 'Python',
                'option_c': 'Java',
                'option_d': 'C++',
                'correct_answer': 'B'
            },
            {
                'question_text': 'What does MVC stand for?',
                'option_a': 'Model View Controller',
                'option_b': 'Multiple View Control',
                'option_c': 'Main View Component',
                'option_d': 'Model Variable Control',
                'correct_answer': 'A'
            }
        ]

        # Create 250+ questions by repeating and modifying
        questions_to_create = []
        for i in range(250):
            base_question = sample_questions[i % len(sample_questions)]
            question = Question(
                course=course,
                question_text=f"{base_question['question_text']} (Question {i+1})",
                option_a=base_question['option_a'],
                option_b=base_question['option_b'],
                option_c=base_question['option_c'],
                option_d=base_question['option_d'],
                correct_answer=base_question['correct_answer']
            )
            questions_to_create.append(question)

        Question.objects.bulk_create(questions_to_create)
        self.stdout.write(
            self.style.SUCCESS(f'Successfully created 250 questions for course: {course.name}')
        )