from django.core.management.base import BaseCommand
from crm.models.office import Office

class Command(BaseCommand):
    help = 'Populate office locations for dynamic address handling'

    def handle(self, *args, **options):
        offices_data = [
            {
                'name': 'Kasaragod Office',
                'location_code': 'kasargod',
                'address': 'Fathima Arcade, Second Floor\nNew Bus Stand, Kasaragod\nBuilding No: 18/339/A7\nPin Code: 671121, Kerala, India\n9995 555 861 / marketizrksd@gmail.com\nGSTIN: 32ACEFM3907A1ZV\nwww.marketizr.in',
                'phone': '9995 555 861',
                'email': 'marketizrksd@gmail.com',
                'website': 'www.marketizr.in',
                'gstin': '32ACEFM3907A1ZV',
                'is_active': True,
                'is_default': True
            },
            {
                'name': 'Calicut Office',
                'location_code': 'calicut',
                'address': 'Marketizr Business Expertise, \n1st Floor KINFRA Advanced Technology Park,\nPoovannor Palli,Ramanattukara\nKozhikode,Kerala 673631\n9995 555 861 / marketizrksd@gmail.com\nGSTIN: 32ACEFM3907A1ZV\nwww.marketizr.in',
                'phone': '9995 555 861',
                'email': 'marketizrksd@gmail.com',
                'website': 'www.marketizr.in',
                'gstin': '32ACEFM3907A1ZV',
                'is_active': True,
                'is_default': False
            }
        ]

        created_count = 0
        updated_count = 0

        for office_data in offices_data:
            office, created = Office.objects.get_or_create(
                location_code=office_data['location_code'],
                defaults=office_data
            )
            
            if created:
                created_count += 1
                self.stdout.write(
                    self.style.SUCCESS(f'Created office: {office.name}')
                )
            else:
                # Update existing office
                for key, value in office_data.items():
                    setattr(office, key, value)
                office.save()
                updated_count += 1
                self.stdout.write(
                    self.style.WARNING(f'Updated office: {office.name}')
                )

        self.stdout.write(
            self.style.SUCCESS(
                f'Successfully processed {len(offices_data)} offices. '
                f'Created: {created_count}, Updated: {updated_count}'
            )
        )
