# Generated by Django 5.2.7 on 2025-10-07 11:20

import django.core.validators
import django.utils.timezone
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ActivateCustomer',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('onboard_status', models.CharField(choices=[('not_started', 'Not Started'), ('in_progress', 'In Progress'), ('pending', 'Pending'), ('done', 'Done'), ('failed', 'Failed')], max_length=20)),
                ('onboard_date', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Campaign',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('campaign_type', models.CharField(choices=[('email', 'Email'), ('sms', 'Sms'), ('offline', 'Offline'), ('social_media', 'Social Media')], default='offline', max_length=30)),
                ('location', models.CharField(choices=[('kozhikode', 'Kozhikode'), ('kasaragod', 'Kasaragod'), ('dubai', 'Dubai'), ('qatar', 'Qatar')], default='kasaragod', max_length=55)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField()),
                ('budget', models.DecimalField(blank=True, decimal_places=2, max_digits=12, null=True)),
                ('expected_revenue', models.DecimalField(blank=True, decimal_places=2, max_digits=12, null=True)),
                ('status', models.CharField(choices=[('planned', 'Planned'), ('active', 'Active'), ('completed', 'Completed'), ('cancelled', 'Cancelled')], default='planned', max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='CollectionData',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('company_name', models.CharField(blank=True, max_length=200, null=True)),
                ('client_name', models.CharField(blank=True, max_length=30, null=True)),
                ('way_of_contact', models.CharField(blank=True, max_length=400, null=True)),
                ('types_of_business', models.CharField(blank=True, max_length=200, null=True)),
                ('place', models.CharField(choices=[('kozhikode', 'Kozhikode'), ('kasaragod', 'Kasaragod'), ('dubai', 'Dubai'), ('qatar', 'Qatar')], default='kasaragod', max_length=20)),
                ('contact_no', models.CharField(blank=True, max_length=16, null=True)),
                ('website', models.TextField(blank=True, null=True)),
                ('social_media', models.TextField(blank=True, null=True)),
                ('gmb', models.TextField(blank=True, null=True)),
                ('interested', models.BooleanField(default=False)),
                ('address', models.TextField(blank=True, null=True)),
                ('city', models.CharField(blank=True, max_length=255, null=True)),
                ('state', models.CharField(blank=True, max_length=255, null=True)),
                ('zip_code', models.CharField(blank=True, max_length=255, null=True)),
                ('country', models.CharField(blank=True, max_length=255, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('invoice_number', models.CharField(max_length=20, unique=True)),
                ('invoice_date', models.DateField()),
                ('currency', models.CharField(choices=[('AED', 'Aed'), ('INR', 'Inr'), ('QAR', 'Qar'), ('USD', 'Usd')], default='INR', max_length=3)),
                ('gst', models.DecimalField(decimal_places=2, default=0.0, help_text='GST percentage', max_digits=5)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('pdf_file', models.FileField(blank=True, null=True, upload_to='media/invoices/')),
                ('mark_as_sent', models.BooleanField(default=False)),
                ('approved', models.BooleanField(default=False)),
                ('pending_amount', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('is_paid', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='InvoiceItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item_name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('qty', models.IntegerField()),
                ('rate', models.DecimalField(decimal_places=2, max_digits=10)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
            ],
        ),
        migrations.CreateModel(
            name='Lead',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('company', models.CharField(max_length=255)),
                ('first_name', models.CharField(max_length=50)),
                ('last_name', models.CharField(max_length=50)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('phone', models.CharField(blank=True, max_length=20, null=True)),
                ('mobile', models.CharField(blank=True, default='', max_length=20)),
                ('lead_source', models.CharField(choices=[('campaign', 'Campaign'), ('website', 'Website'), ('social_media', 'Social Media'), ('referral', 'Referral'), ('cold_call', 'Cold Call'), ('collection', 'Collection')], default='collection', max_length=50)),
                ('lead_status', models.CharField(choices=[('new', 'New'), ('contacted', 'Contacted'), ('qualified', 'Qualified'), ('lost', 'Lost'), ('converted', 'Converted')], default='new', max_length=50)),
                ('address', models.TextField(blank=True, null=True)),
                ('city', models.CharField(blank=True, max_length=255, null=True)),
                ('state', models.CharField(blank=True, max_length=255, null=True)),
                ('zip_code', models.CharField(blank=True, max_length=255, null=True)),
                ('country', models.CharField(max_length=255)),
                ('is_converted', models.BooleanField(default=False)),
                ('converted_date', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Office',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('location_code', models.CharField(choices=[('calicut', 'Calicut'), ('kasargod', 'Kasargod'), ('dubai', 'Dubai'), ('qatar', 'Qatar')], help_text='Unique code for the office location', max_length=20, unique=True)),
                ('address', models.TextField(help_text='Complete office address')),
                ('phone', models.CharField(max_length=20, validators=[django.core.validators.RegexValidator(message='Enter a valid phone number', regex='^[\\+]?[1-9][\\d]{0,15}$')])),
                ('email', models.EmailField(max_length=254)),
                ('website', models.URLField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('is_default', models.BooleanField(default=False, help_text='Default office for new quotes/invoices')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Office',
                'verbose_name_plural': 'Offices',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=12)),
                ('payment_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('payment_method', models.CharField(blank=True, choices=[('Cash', 'Cash'), ('Cheque', 'Cheque'), ('Online', 'Online'), ('UPI', 'Upi'), ('Credit Card', 'Credit Card'), ('Debit Card', 'Debit Card')], default='Cash', max_length=50, null=True)),
                ('transaction_id', models.CharField(blank=True, max_length=100, null=True)),
                ('notes', models.TextField(blank=True, null=True)),
                ('pdf_file', models.FileField(blank=True, null=True, upload_to='media/payments/')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Quote',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('quote_number', models.CharField(max_length=20, unique=True)),
                ('quote_date', models.DateField()),
                ('currency', models.CharField(choices=[('AED', 'Aed'), ('INR', 'Inr'), ('QAR', 'Qar'), ('USD', 'Usd')], default='INR', max_length=3)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('pdf_file', models.FileField(blank=True, null=True, upload_to='media/quotes/')),
                ('mark_as_sent', models.BooleanField(default=False)),
                ('is_invoice_converted', models.BooleanField(default=False)),
                ('total_amount', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='QuoteItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('item_name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('qty', models.IntegerField()),
                ('rate', models.DecimalField(decimal_places=2, max_digits=10)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
            ],
        ),
    ]
