import uuid
from django.db import models
from enum import Enum
from lib.choices import choices_the_options

class OnboardStatus(Enum):
    NOT_STARTED = 'not_started'
    IN_PROGRESS = 'in_progress'
    PENDING = 'pending'
    DONE = 'done'
    FAILED = 'failed'

class ActivateCustomer(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    lead = models.ForeignKey('crm.Lead', on_delete=models.CASCADE, related_name='activate_customers')
    invoice = models.ForeignKey('crm.Invoice', on_delete=models.CASCADE, related_name='activate_customers')
    onboard_status = models.CharField(
        max_length=20,
        choices=choices_the_options(OnboardStatus)
    )
    onboard_date = models.DateTimeField(null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f"ActivateCustomer: {self.lead} - {self.onboard_status}"

    class Meta:
        ordering = ['-created_at']
