<?php
// HTML File Viewer
// This file opens and displays existing HTML files created by the Python script

// Get parameters from command line or URL
$htmlPath = isset($argv[1]) ? $argv[1] : (isset($_GET['html']) ? $_GET['html'] : '');

if (empty($htmlPath)) {
    die("Usage: php pdf_generator.php <html_file_path>\n");
}

// Check if HTML file exists
if (!file_exists($htmlPath)) {
    die("Error: HTML file '$htmlPath' not found.\n");
}

try {
    // Set content type to HTML
    header('Content-Type: text/html; charset=utf-8');
    
    // Read and output the existing HTML file
    $htmlContent = file_get_contents($htmlPath);
    
    if ($htmlContent === false) {
        die("Error: Could not read HTML file '$htmlPath'.\n");
    }
    
    echo $htmlContent;
    
} catch (Exception $e) {
    die("Error opening HTML file: " . $e->getMessage() . "\n");
}
?>
