from django.db import models
import uuid
from lib.choices import choices_the_options
from expence.models.expence import Branch, ExpenseAccount


class SenderAccount(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    name = models.CharField(max_length=255, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.name

class DepositAccount(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    name = models.CharField(max_length=255, null=True, blank=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.name

class FundTransfer(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    sender = models.ForeignKey(SenderAccount, on_delete=models.SET_NULL, null=True, blank=True)
    branch = models.CharField(max_length=255, choices=choices_the_options(Branch), default=Branch.HEAD_OFFICE.value)
    amount_received = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    bank_charges = models.DecimalField(max_digits=10, decimal_places=2, null=True, blank=True)
    payment_date = models.DateField(null=True, blank=True)
    payment_code = models.CharField(max_length=255, null=True, blank=True)
    payment_mode = models.CharField(max_length=255, choices=choices_the_options(ExpenseAccount), default=ExpenseAccount.CASH.value)
    deposit_account = models.ForeignKey(DepositAccount, on_delete=models.SET_NULL, null=True, blank=True)
    reference_number = models.CharField(max_length=255, null=True, blank=True)
    payment_received_receipts = models.FileField(upload_to='media/fund_transfer/', null=True, blank=True)
    notes = models.TextField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f"{self.payment_date} - {self.amount_received}"


    class Meta:
        ordering = ['-created_at']

