from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from .models import ExpenceOfficeExpense, PaidThroughType
from .models.fund import SenderAccount, DepositAccount, FundTransfer
from .serializers import (
    OfficeExpenseSerializer, PaidThroughSerializer,
    SenderAccountSerializer, DepositAccountSerializer, FundTransferSerializer
)

class OfficeExpenseListView(APIView):
    """
    View to list all office expenses.
    """
    def get(self, request, format=None):
        expenses = ExpenceOfficeExpense.objects.all()
        serializer = OfficeExpenseSerializer(expenses, many=True)
        return Response(serializer.data, status=status.HTTP_200_OK)

    def post(self, request, format=None):
        serializer = OfficeExpenseSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)
# Create your views here.

class OfficeExpenseDetailView(APIView):
    """
    View to get a single office expense.
    """
    def get(self, request, pk, format=None):
        expense = ExpenceOfficeExpense.objects.get(pk=pk)
        serializer = OfficeExpenseSerializer(expense)
        return Response(serializer.data, status=status.HTTP_200_OK)

class OfficeExpenseCreateView(APIView):
    """
    View to create a new office expense.
    """
    def post(self, request, format=None):
        serializer = OfficeExpenseSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)

class PaidThroughTypeListView(APIView):
    """
    View to list all paid through types.
    """
    def get(self, request, format=None):
        paid_through_types = PaidThroughType.objects.all()
        serializer = PaidThroughSerializer(paid_through_types, many=True)
        return Response(serializer.data, status=status.HTTP_200_OK)


class SenderAccountListCreateView(APIView):
    def get(self, request, format=None):
        items = SenderAccount.objects.all().order_by('name')
        serializer = SenderAccountSerializer(items, many=True)
        return Response(serializer.data, status=status.HTTP_200_OK)

    def post(self, request, format=None):
        serializer = SenderAccountSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


class DepositAccountListCreateView(APIView):
    def get(self, request, format=None):
        items = DepositAccount.objects.all().order_by('name')
        serializer = DepositAccountSerializer(items, many=True)
        return Response(serializer.data, status=status.HTTP_200_OK)

    def post(self, request, format=None):
        serializer = DepositAccountSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


class FundTransferListCreateView(APIView):
    def get(self, request, format=None):
        items = FundTransfer.objects.select_related('sender', 'deposit_account').order_by('-created_at')
        serializer = FundTransferSerializer(items, many=True)
        return Response(serializer.data, status=status.HTTP_200_OK)

    def post(self, request, format=None):
        serializer = FundTransferSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)