from num2words import num2words

def generate_invoice_number():
    from crm.models import Invoice
    last_invoice = Invoice.objects.order_by('-created_at').first()
    if last_invoice:
        try:
            last_number = int(last_invoice.invoice_number.replace('INV-', ''))
            new_number = last_number + 1
        except (ValueError, AttributeError):
            new_number = Invoice.objects.count() + 1
    else:
        new_number = 1
    return f"INV-{new_number:06d}"


def generate_amount_in_words(amount, currency='INR'):
    try:
        return num2words(amount, to='currency', lang='en_IN', currency=currency).title()
    except Exception:
        return f"{amount} {currency}".title()