"""
URL configuration for marketizr project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.conf import settings
from django.conf.urls.static import static
from django.urls import re_path, path
from users.views import (
    RegisterView, LoginView, LogoutView, UserView, LoginAttemptView,
    UserSecretCodeView, VerifySecretCodeView
)
from subscriptions.views import (
    ProfileView, SalesPersonsView, ExitstEmployeeList
)
from crm.views import (
    LeadViewSet, CollectionDataViewSet,
    CampaignView, CollectionAssignedPerson, LeadConvertedPerson,
    QuoteViewSet, InvoiceViewSet, ActivateCustomerView,
    DashboardStatsAPIView
)
from crm.views.office import OfficeViewSet
from crm.views.lead import CollectionByProfile
from bot.views import (
    GeminiChatView
)
from office.views import (
    CompanyContentCalendarListView, CompanyContentCalendarDetailView,
    ContentCalendarCreateView, ContentCalendarDetailView,
    DailyReportListView, DailyReportDetailView,
    OfficeExpenseListView, OfficeExpenseDetailView,
    ActivityListView, ActivityDetailView, DailyReportByProfileView
)
from tasks.views import (
    TaskListCreateUpdateView, TaskRetrieveUpdateView, TasksByProfileView, TaskManagerListCreateView, TaskManagerRetrieveUpdateView,
    TaskManagerByProfileView
)
from crm.views.quote import PaymentViewSet, ItemTemplateViewSet
from analytics.views import (
    CashTotalPaymentView
)


from expence.views import (
    OfficeExpenseListView, OfficeExpenseDetailView, OfficeExpenseCreateView, PaidThroughTypeListView,
    SenderAccountListCreateView, DepositAccountListCreateView, FundTransferListCreateView
)

from attendance.views import (
    DownloadPunchDataView, DownloadPunchDataMCIDView, DownloadLastPunchDataView
)


from crm.views.delete import (
    CollectionDataDeleteApi, LeadDeleteview
)

from course.views import (
    BatchListView, BatchDetailView, CourseListView, CourseDetailView, CourseEnrollmentView, CourseProgressView, ChapterListView, ChapterDetailView, LessonListView, LessonDetailView, LessonProgressView, UserCoursesView,
    search_courses
)
from course.views_exam import (
    QuestionListCreateView, QuestionDetailView,
    start_exam, submit_exam, leaderboard, search_certificate, download_certificate
)
from course.views import CertificateListAllView

from clients.views import FeedbackView

from analytics.views import (
    CashTotalPaymentView, OtherTotalPaymentView
)

from students.views import (
    StudentsProfile, StudentView, StudentPaymentView, CourseView
)

urlpatterns = [

    # Students Profile

    re_path('api/marketizr/student/payment/create',
            StudentPaymentView.as_view(), name="student-payment-create"),

    re_path('api/marketizr/student/payment/get',
            StudentPaymentView.as_view(), name="student-payment-get"),

    re_path('api/marketizr/student/course/create',
            CourseView.as_view(), name="course-create"),
            
    re_path('api/marketizr/student/course/get',
            CourseView.as_view(), name="course-get"),


    re_path('api/marketizr/student/create',
            StudentView.as_view(), name="student-create"),

    re_path('api/marketizr/student/get',
            StudentView.as_view(), name='student-get'),

    # Accounts

    re_path('api/marketizr/cash/total/payment',
            CashTotalPaymentView.as_view(), name="cash-total"),

re_path('api/marketizr/other/total/payment',
            OtherTotalPaymentView.as_view(), name="other-total"),

    # Clients API
    re_path('api/marketizr/feedback/create',
            FeedbackView.as_view(), name='create-feedback'),
    re_path('api/marketizr/feedback/get',
            FeedbackView.as_view(), name='get-feedback'),

    # Batch URLs
    re_path('api/academy/batches/', BatchListView.as_view(), name='batch-list'),
    re_path('api/academy/batches/<uuid:pk>/',
            BatchDetailView.as_view(), name='batch-detail'),

    # Course URLs
    re_path('api/academy/courses/',
            CourseListView.as_view(), name='course-list'),
    re_path('api/academy/courses/search/',
            search_courses, name='course-search'),
    re_path('api/academy/courses/<uuid:pk>/',
            CourseDetailView.as_view(), name='course-detail'),
    re_path('api/academy/courses/<uuid:course_id>/enroll/',
            CourseEnrollmentView.as_view(), name='course-enroll'),
    re_path('api/academy/courses/<uuid:course_id>/progress/',
            CourseProgressView.as_view(), name='course-progress'),

    # Chapter URLs
    re_path('api/academy/courses/<uuid:course_id>/chapters/',
            ChapterListView.as_view(), name='chapter-list'),
    re_path('api/academy/chapters/<uuid:pk>/',
            ChapterDetailView.as_view(), name='chapter-detail'),

    # Lesson URLs
    re_path('api/academy/chapters/<uuid:chapter_id>/lessons/',
            LessonListView.as_view(), name='lesson-list'),
    re_path('api/academy/lessons/<uuid:pk>/',
            LessonDetailView.as_view(), name='lesson-detail'),
    re_path('api/academy/lessons/<uuid:lesson_id>/progress/',
            LessonProgressView.as_view(), name='lesson-progress'),

    # User-specific URLs
    re_path('api/academy/my-courses/',
            UserCoursesView.as_view(), name='user-courses'),

    # Exam URLs - Question management (Trainers only)
    re_path('api/academy/courses/<uuid:course_id>/questions/',
            QuestionListCreateView.as_view(), name='question-list-create'),
    re_path('api/academy/questions/<uuid:pk>/',
            QuestionDetailView.as_view(), name='question-detail'),

    # Exam functionality
    re_path('api/academy/courses/<uuid:course_id>/exam/start/',
            start_exam, name='start-exam'),
    re_path('api/academy/exams/<uuid:exam_id>/submit/',
            submit_exam, name='submit-exam'),

    # Leaderboard
    re_path('api/academy/leaderboard/', leaderboard, name='leaderboard'),
    re_path('api/academy/courses/<uuid:course_id>/leaderboard/',
            leaderboard, name='course-leaderboard'),

    # Certificate search
    re_path('api/academy/certificates/search/',
            search_certificate, name='search-certificate'),
    re_path('api/academy/certificates/all/',
            CertificateListAllView.as_view(), name='certificate-list-all'),
    re_path(
        r'^api/academy/certificates/(?P<certificate_id>[0-9a-f-]{36})/download/$', download_certificate, name='download-certificate'),

    # Delete Api
    re_path(r'^api/marketizr/collections-delete/(?P<pk>[0-9a-fA-F-]+)/$',
            CollectionDataDeleteApi.as_view(), name='collection-data-delete'),
    re_path(
        r'^api/marketizr/leads-delete/(?P<pk>[0-9a-fA-F-]+)/$', LeadDeleteview.as_view(), name=""),


    # Payment totals and invoice lists by method
    re_path('api/marketizr/payments/total/cash/',
            CashTotalPaymentView.as_view(), name='payments-total-cash'),

    # Attendance App
    re_path('api/marketizr/attendance/download-punch-data/',
            DownloadPunchDataView.as_view(), name='download-punch-data'),
    re_path('api/marketizr/attendance/download-punch-data-mcid/',
            DownloadPunchDataMCIDView.as_view(), name='download-punch-data-mcid'),
    re_path('api/marketizr/attendance/download-last-punch-data/',
            DownloadLastPunchDataView.as_view(), name='download-last-punch-data'),
    # Attendance App End

    # Dashboard View
    re_path('api/marketizr/dashboard/',
            DashboardStatsAPIView.as_view(), name='dashboard-view'),

    # Users App

    re_path('api/marketizr/admin/', admin.site.urls),
    re_path('api/marketizr/register/',
            RegisterView.as_view(), name='register'),
    re_path('api/marketizr/login/', LoginView.as_view(), name='login'),
    re_path('api/marketizr/logout/', LogoutView.as_view(), name='logout'),
    re_path('api/marketizr/users/', UserView.as_view(), name='users'),
    re_path('api/marketizr/get/login/attempts/',
            LoginAttemptView.as_view(), name='get-attempts'),
    re_path('api/marketizr/update/secret-code/forget-password',
            UserSecretCodeView.as_view(), name='update-secret-code'),
    re_path('api/marketizr/verify/secret-code/forget-password',
            VerifySecretCodeView.as_view(), name='verify-secret-code'),

    # End Users App

    # Bot
    re_path('api/marketizr/chat/', GeminiChatView.as_view(), name='gemini-chat'),


    # Activate Users

    re_path('api/marketizr/activate/users',
            ActivateCustomerView.as_view(), name='activate-users'),

    # End


    # Expense App
    re_path(r'^api/marketizr/office-expenses/(?P<pk>[0-9a-fA-F-]+)/$',
            OfficeExpenseDetailView.as_view(), name='office-expense-detail'),
    re_path(r'^api/marketizr/office-expenses/create/$',
            OfficeExpenseListView.as_view(), name='create-office-expenses'),
    re_path(r'^api/marketizr/office-expenses/$',
            OfficeExpenseListView.as_view(), name='office-expenses'),
    re_path(r'^api/marketizr/paid-through-types/$',
            PaidThroughTypeListView.as_view(), name='paid-through-types'),

    # Fund transfer endpoints
    re_path(r'^api/marketizr/fund/senders/$',
            SenderAccountListCreateView.as_view(), name='fund-sender-list-create'),
    re_path(r'^api/marketizr/fund/deposits/$',
            DepositAccountListCreateView.as_view(), name='fund-deposit-list-create'),
    re_path(r'^api/marketizr/fund/transfers/$',
            FundTransferListCreateView.as_view(), name='fund-transfer-list-create'),




    # Task Manager App
    re_path(r"^api/marketizr/task-managers/$",
            TaskManagerListCreateView.as_view(), name="task-manager-list"),
    re_path(r"^api/marketizr/task-managers/(?P<id>[0-9a-fA-F-]+)/$",
            TaskManagerRetrieveUpdateView.as_view(), name="task-manager-detail"),

    # Task Manager App End

    # Office App
    re_path(r'^api/marketizr/company-content-calendars/(?P<pk>[0-9a-fA-F-]+)/$',
            CompanyContentCalendarDetailView.as_view(), name='company-content-calendar-detail'),
    re_path(r'^api/marketizr/company-content-calendars/create/$',
            CompanyContentCalendarListView.as_view(), name='create-company-content-calendars'),
    re_path(r'^api/marketizr/company-content-calendars/$',
            CompanyContentCalendarListView.as_view(), name='company-content-calendars'),

    re_path(r'^api/marketizr/content-calendar/(?P<pk>[0-9a-fA-F-]+)/$',
            ContentCalendarDetailView.as_view(), name='content-calendar-detail'),
    re_path(r'^api/marketizr/content-calendar/create/$',
            ContentCalendarCreateView.as_view(), name='create-content-calendar'),
    re_path(r'^api/marketizr/content-calendar/$',
            ContentCalendarCreateView.as_view(), name='get-content-calendar'),

    re_path(r'^api/marketizr/daily-reports/(?P<pk>[0-9a-fA-F-]+)/$',
            DailyReportDetailView.as_view(), name='daily-report-detail'),
    re_path(r'^api/marketizr/daily-reports/create/$',
            DailyReportListView.as_view(), name='create-daily-reports'),
    re_path(r'^api/marketizr/daily-reports/$',
            DailyReportListView.as_view(), name='daily-reports'),
    re_path(r'^api/marketizr/daily-reports/profile/(?P<uuid>[0-9a-fA-F-]+)/$',
            DailyReportByProfileView.as_view(), name='daily-reports-by-profile'),

    re_path(r'^api/marketizr/office-expenses/(?P<pk>[0-9a-fA-F-]+)/$',
            OfficeExpenseDetailView.as_view(), name='office-expense-detail'),
    re_path(r'^api/marketizr/office-expenses/create/$',
            OfficeExpenseListView.as_view(), name='create-office-expenses'),
    re_path(r'^api/marketizr/office-expenses/$',
            OfficeExpenseListView.as_view(), name='office-expenses'),

    re_path(r'^api/marketizr/activities/(?P<pk>[0-9a-fA-F-]+)/$',
            ActivityDetailView.as_view(), name='activity-detail'),
    re_path(r'^api/marketizr/activities/create/$',
            ActivityListView.as_view(), name='create-activities'),
    re_path(r'^api/marketizr/activities/$',
            ActivityListView.as_view(), name='activities'),
    # Office App End

    # Tasks App
    re_path(r"^api/marketizr/tasks/$",
            TaskListCreateUpdateView.as_view(), name="task-list"),
    re_path(r"^api/marketizr/tasks/(?P<id>[0-9a-fA-F-]+)/$",
            TaskRetrieveUpdateView.as_view(), name="task-detail"),
    re_path(
        r'^api/marketizr/allotted-tasks/assigned-person/(?P<uuid>[0-9a-fA-F-]+)/$',
        TaskManagerByProfileView.as_view({'get': 'list'}),
        name='allotted-tasks-assigned-person'
    ),
    re_path(
        r'^api/marketizr/tasks/assigned-person/(?P<uuid>[0-9a-fA-F-]+)/$',
        TasksByProfileView.as_view({'get': 'list'}),
        name='collection-assigned-person'
    ),
    # Tasks App End

    # Collection

    re_path(
        r'^api/marketizr/collections/assigned-person/(?P<uuid>[0-9a-fA-F-]+)/$',
        CollectionAssignedPerson.as_view({'get': 'list'}),
        name='collection-assigned-person'
    ),

    # Collections by profile (profile owns the collection rows)
    re_path(
        r'^api/marketizr/collections/profile/(?P<profile_id>[0-9a-fA-F-]+)/$',
        CollectionByProfile.as_view({'get': 'list'}),
        name='collection-by-profile'
    ),

    re_path(
        r'^api/marketizr/leads/converted/$',
        LeadConvertedPerson.as_view({'get': 'list'}),
        name='leads-converted-person'
    ),

    re_path('api/marketizr/campaigns/create',
            CampaignView.as_view(), name='create-campaigns'),
    re_path('api/marketizr/campaigns/',
            CampaignView.as_view(), name='get-campaigns'),

    re_path('api/marketizr/salespersons/',
            SalesPersonsView.as_view(), name='salespersons'),

    # Subscription  App
    re_path('api/marketizr/profile/create',
            ProfileView.as_view(), name='create-profile'),
    re_path('api/marketizr/get/profile/',
            ProfileView.as_view(), name='get-profile'),

    re_path(r'^api/marketizr/profile/update/(?P<pk>[0-9a-fA-F-]+)/$', 
        ProfileView.as_view(), name='update-profile'),


    re_path('api/marktizr/exitst/profile', ExitstEmployeeList.as_view(),
            name='profile-exist-view'),
    # Subscription Routes End


    # Quote App
    re_path(
        r'^api/marketizr/quotes/$',
        QuoteViewSet.as_view({
            'get': 'list',
            'post': 'create'
        }),
        name='quote-list'
    ),

    re_path(
        r'^api/marketizr/quotes/(?P<pk>[0-9a-fA-F-]+)/$',
        QuoteViewSet.as_view({
            'get': 'retrieve',
            'put': 'update',
            'patch': 'partial_update',
            'delete': 'destroy'
        }),
        name='quote-detail'
    ),

    re_path(
        r'^api/marketizr/quotes/(?P<pk>[0-9a-fA-F-]+)/convert-to-invoice/$',
        QuoteViewSet.as_view({'post': 'convert_to_invoice'}),
        name='quote-convert-to-invoice'
    ),

    re_path(
        r'^api/marketizr/quotes/(?P<pk>[0-9a-fA-F-]+)/get-invoice/$',
        QuoteViewSet.as_view({'get': 'get_invoice'}),
        name='quote-get-invoice'
    ),

    re_path(
        r'^api/marketizr/invoices/$',
        InvoiceViewSet.as_view({
            'get': 'list',
            'post': 'create'
        }),
        name='invoice-list'
    ),

    re_path(
        r'^api/marketizr/invoices/(?P<pk>[0-9a-fA-F-]+)/$',
        InvoiceViewSet.as_view({
            'get': 'retrieve',
            'put': 'update',
            'patch': 'partial_update',
            'delete': 'destroy'
        }),
        name='invoice-detail'
    ),

    # Start of collection Selection
    re_path(
        r'^api/marketizr/collections/$',
        CollectionDataViewSet.as_view({
            'get': 'list',
            'post': 'create'
        }),
        name='collection-list'
    ),

    re_path(
        r'^api/marketizr/collections/(?P<pk>[0-9a-fA-F-]+)/$',
        CollectionDataViewSet.as_view({
            'get': 'retrieve',
            'put': 'update',
            'patch': 'partial_update',
            'delete': 'destroy'
        }),
        name='collection-detail'
    ),

    re_path(
        r'^api/marketizr/collections/(?P<pk>[0-9a-fA-F-]+)/convert-to-lead/$',
        CollectionDataViewSet.as_view({'post': 'convert_to_lead'}),
        name='collection-convert-to-lead'
    ),

    # Lead endpoints
    re_path(
        r'^api/marketizr/leads/$',
        LeadViewSet.as_view({
            'get': 'list',
            'post': 'create'
        }),
        name='lead-list'
    ),
    re_path(
        r'^api/marketizr/leads/(?P<pk>[0-9a-fA-F-]+)/$',
        LeadViewSet.as_view({
            'get': 'retrieve',
            'put': 'update',
            'patch': 'partial_update',
            'delete': 'destroy'
        }),
        name='lead-detail'
    ),
    re_path(
        r'^api/marketizr/leads/(?P<pk>[0-9a-fA-F-]+)/convert-to-customer/$',
        LeadViewSet.as_view({'post': 'convert_to_customer'}),
        name='lead-convert-to-customer'
    ),

    re_path(
        r'^api/marketizr/payments/$',
        PaymentViewSet.as_view({
            'get': 'list',
            'post': 'create'
        }),
        name='payment-list'
    ),

    # Item Templates API
    re_path(
        r'^api/marketizr/item-templates/$',
        ItemTemplateViewSet.as_view({
            'get': 'list',
            'post': 'create'
        }),
        name='item-template-list'
    ),
    re_path(
        r'^api/marketizr/item-templates/(?P<pk>[0-9a-fA-F-]+)/$',
        ItemTemplateViewSet.as_view({
            'get': 'retrieve',
            'put': 'update',
            'patch': 'partial_update',
            'delete': 'destroy'
        }),
        name='item-template-detail'
    ),


    # Office Locations API
    re_path(
        r'^api/marketizr/office-locations/$',
        OfficeViewSet.as_view({
            'get': 'list',
            'post': 'create'
        }),
        name='office-locations-list'
    ),
    re_path(
        r'^api/marketizr/office-locations/(?P<pk>[0-9a-fA-F-]+)/$',
        OfficeViewSet.as_view({
            'get': 'retrieve',
            'put': 'update',
            'patch': 'partial_update',
            'delete': 'destroy'
        }),
        name='office-locations-detail'
    ),
    re_path(
        r'^api/marketizr/office-locations/default/$',
        OfficeViewSet.as_view({'get': 'default'}),
        name='office-locations-default'
    ),
    re_path(
        r'^api/marketizr/office-locations/by-location/$',
        OfficeViewSet.as_view({'get': 'by_location'}),
        name='office-locations-by-location'
    ),
    # re_path(
    #     r'^api/marketizr/payments/(?P<pk>[0-9a-fA-F-]+)/$',
    #     PaymentViewSet.as_view({
    #         'get': 'retrieve',
    #         'put': 'update',
    #         'patch': 'partial_update',
    #         'delete': 'destroy'
    #     }),
    #     name='payment-detail'
    # ),
]

# if settings.DEBUG:
#     urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
#     urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)


if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL,
                          document_root=settings.MEDIA_ROOT)
