# Generated by Django 5.2.7 on 2025-11-06 11:50

import django.db.models.deletion
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Course',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('course_name', models.CharField(blank=True, max_length=100, null=True)),
                ('course_fee', models.DecimalField(decimal_places=2, max_digits=10)),
                ('course_duration', models.CharField(blank=True, max_length=100, null=True)),
                ('course_description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Student',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('student_course', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('phone_number', models.CharField(blank=True, max_length=15, null=True)),
                ('batch', models.CharField(blank=True, max_length=100, null=True)),
                ('is_online', models.BooleanField(default=False)),
                ('student_name', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='courses', to='students.course')),
            ],
        ),
        migrations.CreateModel(
            name='StudentPayment',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('payment_date', models.DateField(auto_now_add=True)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('payment_method', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True, null=True)),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='students', to='students.student')),
            ],
        ),
    ]
