from django.db import models
import uuid
from crm.models.payments import PaymentMethod
from lib.choices import choices_the_options
# from subscriptions.models import Profile


class Course(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    course_name = models.CharField(max_length=100, null=True, blank=True)
    course_fee = models.DecimalField(max_digits=10, decimal_places=2)
    course_duration = models.CharField(max_length=100, null=True, blank=True)
    course_description = models.TextField(null=True, blank=True)

    def __str__(self):
        return self.course_name


class Student(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    student_name = models.CharField(max_length=15, null=True, blank=True)
    student_course = models.CharField(max_length=150, null=True, blank=True)
    email = models.EmailField(null=True, blank=True)
    phone_number = models.CharField(max_length=15, null=True, blank=True)
    batch = models.CharField(max_length=100, null=True, blank=True)
    is_online = models.BooleanField(default=False)

    def __str__(self):
        return str(self.email)
    
class StudentPayment(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    student = models.ForeignKey(
        Student, on_delete=models.CASCADE, related_name='payments')
    payment_date = models.DateField(auto_now_add=True)
    amount = models.DecimalField(max_digits=10, decimal_places=2)
    payment_method = models.CharField(max_length=50, choices=choices_the_options(
        PaymentMethod), default=PaymentMethod.CASH.value)
    description = models.TextField(blank=True, null=True)

    def student_pending_amount(self):
        pass



  
