from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from students.models import Student, Course, StudentPayment
from subscriptions.models import Profile
from subscriptions.serializers import ProfileSerializers
from students.serializers import StudentPaymentSerializer, StudentSerializer, CourseSerializer
from lib.permission import UserRole


class StudentsProfile(APIView):
    # def get(self, request):
    #     students = Profile.objects.filter(user__role = UserRole.STUDENT.value)
    #     serializer = ProfileSerializers(students, many=True)
    #     return Response(serializer.data)
    pass

# Create your views here.
class  StudentView(APIView):
    def get(self, request):
        students = Student.objects.all()
        serializer = StudentSerializer(students, many=True)
        return Response(serializer.data)

    def post(self, request):
        serializer = StudentSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)
    

# Create your views here.
class StudentPaymentView(APIView):
    def get(self, request):
        students = StudentPayment.objects.all()
        serializer = StudentPaymentSerializer(students, many=True)
        return Response(serializer.data)

    def post(self, request):
        serializer = StudentPaymentSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)
    
#  Create your views here.
class CourseView(APIView):
    def get(self, request):
        students = Course.objects.all()
        serializer = CourseSerializer(students, many=True)
        return Response(serializer.data)

    def post(self, request):
        serializer = CourseSerializer(data=request.data)
        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)