# Generated by Django 5.2.7 on 2025-10-07 11:20

import django.db.models.deletion
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('crm', '0001_initial'),
        ('subscriptions', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('open', 'Open'), ('in_progress', 'In Progress'), ('review', 'Review'), ('completed', 'Completed')], default='open', max_length=20)),
                ('priority', models.CharField(choices=[('low', 'Low'), ('normal', 'Normal'), ('high', 'High'), ('urgent', 'Urgent')], default='low', max_length=20)),
                ('due_date', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
                ('assignee', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assigned_tasks', to='subscriptions.profile')),
                ('reporter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reported_tasks', to='subscriptions.profile')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='TaskManager',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('date', models.DateField(auto_now_add=True, null=True)),
                ('job_order_no', models.CharField(blank=True, max_length=255, null=True)),
                ('activities', models.CharField(blank=True, max_length=255, null=True)),
                ('work_details', models.TextField(blank=True, null=True)),
                ('division', models.CharField(blank=True, choices=[('design', 'Design'), ('video', 'Video'), ('website', 'Website')], max_length=255, null=True)),
                ('allotted_date', models.DateField(blank=True, null=True)),
                ('target_date', models.DateField(blank=True, null=True)),
                ('designed_status', models.CharField(blank=True, choices=[('open', 'Open'), ('under_design', 'Under Design'), ('completed', 'Completed')], max_length=255, null=True)),
                ('completed_date', models.DateField(blank=True, null=True)),
                ('client_status', models.CharField(blank=True, choices=[('approved', 'Approved'), ('open', 'Open'), ('under_review', 'Under Review'), ('rejected', 'Rejected')], max_length=255, null=True)),
                ('remarks', models.TextField(blank=True, null=True)),
                ('billing', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('allotted_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='allotted_by_tasks', to='subscriptions.profile')),
                ('client_name', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='client_name_tasks', to='crm.lead')),
                ('designed_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='designed_by_tasks', to='subscriptions.profile')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
    ]
