def generate_invoice_number():
    from crm.models import Invoice  # Import inside function to avoid circular import
    last_invoice = Invoice.objects.order_by('-created_at').first()
    if last_invoice:
        try:
            last_number = int(last_invoice.invoice_number.replace('INV-', ''))
            new_number = last_number + 1
        except (ValueError, AttributeError):
            new_number = Invoice.objects.count() + 1
    else:
        new_number = 1
    return f"INV-{new_number:06d}"